import { IPostTransmissionTelemetryItem } from "./DataModels";
/**
* This class defines a "batch" events related to a specific iKey, it is used by the PostChannel and HttpManager
* to collect and transfer ownership of events without duplicating them in-memory. This reduces the previous
* array duplication and shared ownership issues that occurred due to race conditions caused by the async nature
* of sending requests.
*/
export declare class EventBatch {
    /**
     * Creates a new Event Batch object
     * @param iKey The iKey associated with this batch of events
     */
    static create(iKey: string, theEvents?: IPostTransmissionTelemetryItem[]): EventBatch;
    /**
     * Returns the iKey associated with this batch of events
     */
    iKey: () => string;
    /**
     * Returns the first msfpc value from the batch
     */
    Msfpc: () => string;
    /**
     * Returns the number of events contained in the batch
     */
    count: () => number;
    events: () => IPostTransmissionTelemetryItem[];
    /**
     * Add all of the events to the current batch, if the max number of events would be exceeded then no
     * events are added.
     * @param theEvents - The events that needs to be batched.
     * @returns The number of events added.
     */
    addEvent: (theEvents: IPostTransmissionTelemetryItem) => boolean;
    /**
     * Split this batch into 2 with any events > fromEvent returned in the new batch and all other
     * events are kept in the current batch.
     * @param fromEvent The first event to remove from the current batch.
     * @param numEvents The number of events to be removed from the current batch and returned in the new one. Defaults to all trailing events
     */
    split: (fromEvent: number, numEvents?: number) => EventBatch;
    /**
     * Private constructor so that caller is forced to use the static create method.
     * @param iKey - The iKey to associate with the events (not validated)
     * @param addEvents - The optional collection of events to assign to this batch - defaults to an empty array.
     */
    private constructor();
}
