import { IExperimentationFilterProvider } from '../../contracts/IExperimentationFilterProvider';
import { AxiosHttpClient } from '../Util/AxiosHttpClient';
import { IExperimentationTelemetry } from '../../contracts/IExperimentationTelemetry';
import { FilteredFeatureProvider } from './FilteredFeatureProvider';
import { FeatureData, ConfigData } from './IFeatureProvider';
export declare const TASAPI_FETCHERROR_EVENTNAME = "call-tas-error";
/**
 * Feature provider implementation that calls the TAS web service to get the most recent active features.
 */
export declare class TasApiFeatureProvider extends FilteredFeatureProvider {
    protected httpClient: AxiosHttpClient;
    protected telemetry: IExperimentationTelemetry;
    protected filterProviders: IExperimentationFilterProvider[];
    constructor(httpClient: AxiosHttpClient, telemetry: IExperimentationTelemetry, filterProviders: IExperimentationFilterProvider[]);
    /**
     * Method that handles fetching of latest data (in this case, flights) from the provider.
     */
    fetch(): Promise<FeatureData>;
}
export interface TASFeatureData {
    Features: any[];
    Flights: any[];
    Configs: ConfigData[];
    ParameterGroups: any[];
    FlightingVersion: number;
    ImpressionId: string;
    FlightingEnrichments: any;
    AssignmentContext: string;
}
